<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Authenticate Document</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <style>
    * {
      box-sizing: border-box;
    }

    body {
      margin: 0;
      padding: 0;
      font-family: Arial, sans-serif;
      background: url('img/background_industry.jpg') no-repeat center center fixed;
      background-size: cover;
    }

    .header {
      background-color: #00049e;
      color: white;
      padding: 20px;
      display: flex;
      align-items: center;
      gap: 15px;
    }

    .header img {
      height: 70px;
      width: auto;
    }

    .header-text {
      font-size: 26px;
      font-weight: normal;
    }

    .bubble-box {
      position: relative;
      max-width: 650px;
      margin: 20px auto;
      background: linear-gradient(to bottom, #999, #fff 70%);
      padding: 30px;
      border-radius: 15px 15px 5px 5px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    .bubble-box p {
      font-size: 18px;
      font-weight: normal;
      margin-bottom: 15px;
      color: #000;
    }

    .form-wrapper {
      display: flex;
      flex-wrap: wrap;
      gap: 10px;
    }

    .label-box {
      background-color: #ccc;
      padding: 10px;
      font-size: 16px;
      min-width: 150px;
      text-align: center;
      border-radius: 4px;
      flex: 1 1 100%;
    }

    input[type="text"] {
      flex: 1 1 auto;
      padding: 10px;
      font-size: 16px;
      border: 1px solid #ccc;
      border-radius: 4px;
      width: 100%;
    }

    button {
      background-color: #002f99;
      border: none;
      padding: 10px 15px;
      cursor: pointer;
      border-radius: 4px;
      display: flex;
      align-items: center;
      justify-content: center;
    }

    button img {
      width: 20px;
      height: 20px;
    }

    .bubble-arrow {
      position: absolute;
      bottom: -30px;
      right: 20px;
      width: 60px;
      height: auto;
      opacity: 0.7;
      z-index: 1;
      pointer-events: none;
    }

    @media (max-width: 600px) {
      .header {
        flex-direction: column;
        align-items: flex-start;
        padding: 15px;
      }

      .header img {
        height: 50px;
      }

      .header-text {
        font-size: 20px;
      }

      .form-wrapper {
        flex-direction: column;
      }

      .label-box {
        flex: 1 1 auto;
      }

      input[type="text"], button {
        width: 100%;
      }

      button {
        margin-top: 10px;
      }
    }

  </style>
</head>
<body>

  <div class="header">
    <img src="img/fingerprint.png" alt="Fingerprint Icon">
    <div class="header-text">Authenticate your document</div>
  </div>

  <div class="bubble-box">
    <p>Please search your e-document by filling the document number.</p>

    <form action="view.php" method="get" class="form-wrapper">
      <div class="label-box">Document number:</div>
      <input type="text" name="cert_id" placeholder="Enter document number" required />
      <button type="submit">
        <img src="https://img.icons8.com/ios-filled/50/ffffff/search--v1.png" alt="Search" />
      </button>
    </form>

    <!-- Optional image below the form as decorative arrow or logo -->
  </div>

  <script>
    // Disable right-click and F12/Inspect
    document.addEventListener('contextmenu', e => e.preventDefault());
    document.onkeydown = function (e) {
      if (e.keyCode == 123 || (e.ctrlKey && e.shiftKey && e.keyCode == 'I'.charCodeAt(0)))
        return false;
    };
  </script>

</body>
</html>
