<?php
require_once 'qrlib/phpqrcode/qrlib.php'; // include your QR code library

// OLD DB
$oldDb = new mysqli("localhost", "buracyqv_user", "Red@apple@2299", "buracyqv_dbname");
if ($oldDb->connect_error) die("Old DB failed: " . $oldDb->connect_error);

// NEW DB (Remote)
$newDb = new mysqli("srv2067.hstgr.io", "u175020854_mydbuser", "RedVertius@1221", "u175020854_mydbname");
if ($newDb->connect_error) die("Remote DB failed: " . $newDb->connect_error);

// Read POST
$cert_id           = $_POST['cert_id'];
$published_on      = $_POST['published_on'];
$qr_code_status    = $_POST['qr_code_status'];
$name              = $_POST['name'];
$person_id         = $_POST['person_id'];
$issued_on         = $_POST['issued_on'];
$valid_until       = $_POST['valid_until'];
$course_type       = $_POST['course_type'];
$model             = $_POST['model'];
$company           = $_POST['company'];
$training_location = $_POST['training_location'];
$trainer_name      = $_POST['trainer_name'];
$alignment         = $_POST['alignment'];

// Generate SHA256 token

function generateCapitalToken($length = 160) {
    $chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
    $token = '';
    for ($i = 0; $i < $length; $i++) {
        $token .= $chars[random_int(0, strlen($chars) - 1)];
    }
    return $token;
}

$token = generateCapitalToken(120);
//$token = hash('sha256', uniqid(mt_rand(), true));

// Barcode URL
$br_code_url = "https://e-certificates.buraeuveritase.com/" . $token;

// SQL insert
$query = "INSERT INTO certificates
(cert_id, token, published_on, qr_code_status, name, person_id, issued_on, valid_until, course_type, model, company, training_location, trainer_name, br_code_url, alignment)
VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

// OLD DB insert
$oldStmt = $oldDb->prepare($query);
$oldStmt->bind_param("sssssssssssssss", $cert_id, $token, $published_on, $qr_code_status, $name, $person_id, $issued_on, $valid_until, $course_type, $model, $company, $training_location, $trainer_name, $br_code_url, $alignment);
$okOld = $oldStmt->execute();

// NEW DB insert
$newStmt = $newDb->prepare($query);
$newStmt->bind_param("sssssssssssssss", $cert_id, $token, $published_on, $qr_code_status, $name, $person_id, $issued_on, $valid_until, $course_type, $model, $company, $training_location, $trainer_name, $br_code_url, $alignment);
$okNew = $newStmt->execute();

// Display result
if ($okOld && $okNew) {
    echo "<h2 style='color:green;'>✅ Certificate Inserted Successfully!</h2>";
    echo "<p>Barcode URL: <a href='" . htmlspecialchars($br_code_url) . "' target='_blank'>" . htmlspecialchars($br_code_url) . "</a></p>";

    // Generate QR code dynamically as data URI
    ob_start();
    QRcode::png($br_code_url, null, QR_ECLEVEL_H, 6);
    $imageString = base64_encode(ob_get_contents());
    ob_end_clean();

    echo "<p><img src='data:image/png;base64," . $imageString . "' alt='QR Code'></p>";

    // Download button (forces download)
    echo "<p><a href='data:image/png;base64," . $imageString . "' download='certificate_qr.png'><button style='padding:10px 20px;font-size:16px;background:#007bff;color:white;border:none;border-radius:6px;cursor:pointer;'>Download QR Code</button></a></p>";
} else {
    echo "<h2 style='color:red;'>❌ Certificate Insert Failed</h2>";
    if (!$okOld) echo "<p>Old DB Error: " . htmlspecialchars($oldStmt->error) . "</p>";
    if (!$okNew) echo "<p>New DB Error: " . htmlspecialchars($newStmt->error) . "</p>";
    echo "<p><a href='add_certificate.php'>← Back to Add Certificate</a></p>";
}
?>
